// XISLSwitchTag.cpp: CXISLSwitchTag NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLSwitchTag.h"
#include "XISLCaseTag.h"
#include "XISLCallTag.h"
#include "XISLVar.h"
#include "XISLExcItem.h"
#include "XISLIfTag.h"
#include "XISLIfChildTag.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CXISLSwitchTag::CXISLSwitchTag()
{
	m_nTagType = ID_TAG_SWITCH;
	m_nBmpID = IDB_CONDITION;

	m_pParentTag = NULL;
	m_pExprVar = NULL;
}

CXISLSwitchTag::~CXISLSwitchTag()
{
	while(!m_CaseList.IsEmpty())
	{
		CXISLCaseTag *pTag = (CXISLCaseTag*)m_CaseList.RemoveHead();
		delete pTag;
	}
}

CXISLSwitchTag::CXISLSwitchTag(const CXISLSwitchTag &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;

	m_pExprVar = cpXISL.m_pExprVar;
	while(!m_CaseList.IsEmpty())
	{
		CXISLCaseTag *pTag = (CXISLCaseTag*)m_CaseList.RemoveHead();
		delete pTag;
	}
	POSITION pos = cpXISL.m_CaseList.GetHeadPosition();
	while(pos)
		m_CaseList.AddTail(cpXISL.m_CaseList.GetNext(pos));
}

CXISLSwitchTag& CXISLSwitchTag::operator=(const CXISLSwitchTag &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		m_pExprVar = cpXISL.m_pExprVar;
		while(!m_CaseList.IsEmpty())
		{
			CXISLCaseTag *pTag = (CXISLCaseTag*)m_CaseList.RemoveHead();
			delete pTag;
		}
		POSITION pos = cpXISL.m_CaseList.GetHeadPosition();
		while(pos)
			m_CaseList.AddTail(cpXISL.m_CaseList.GetNext(pos));
	}
	return *this;
}

LPCTSTR CXISLSwitchTag::GetXISLString()
{
	CString strName;
	m_pExprVar->GetVarNameEx(strName);
	m_strXISL = "<switch expr = \"";
	m_strXISL += strName;
	m_strXISL += "\">\r\n";

	POSITION pos = m_CaseList.GetHeadPosition();
	while(pos)
	{
		CXISLCaseTag *pCTag = (CXISLCaseTag*)m_CaseList.GetNext(pos);
		m_strXISL += pCTag->GetXISLString();
	}

	m_strXISL += "</switch>\r\n";
	return m_strXISL;
}

//BOOL CXISLSwitchTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
//@\@Fc[Rg[XISL^Oo^
//@FCTreeCtrl *pTree  :o^c[Rg[
//		  HTREEITEM hParent :eڂ̃nh
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLSwitchTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
{
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[ID_TAG_SWITCH];
	tvi.lParam = (LPARAM)this;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pTree->InsertItem(&tvs);
	m_htreeItem = hParent;

	POSITION pos = m_CaseList.GetHeadPosition();
	while(pos)
	{
		CXISLCaseTag *pCTag = (CXISLCaseTag*)m_CaseList.GetNext(pos);
		pCTag->RegistXISLTree(pTree,hParent);
	}

	return TRUE;
}

//int CXISLSwitchTag::GetItemCount()
//@\@FactionȉXISL̃c[ڐԂ
//@F
//߂lFintCc[ڐ
int CXISLSwitchTag::GetItemCount()
{
	int nCount = 0;
	POSITION pos = m_CaseList.GetHeadPosition();
	while(pos)
	{
		CXISLCaseTag *pCTag = (CXISLCaseTag*)m_CaseList.GetNext(pos);
//		nCount += pCTag->GetItemCount();
	}
	nCount++;  //<switch>̕

	return nCount;
}

BOOL CXISLSwitchTag::HasOtherTag()
{
	if(m_CaseList.IsEmpty())
		return FALSE;
	CXISLCaseTag *pTag = (CXISLCaseTag*)m_CaseList.GetTail();
	if(pTag->m_nTagType == ID_TAG_OTHER)
		return TRUE;
	else
		return FALSE;
}

LPCTSTR CXISLSwitchTag::GetExpr()
{
	if(m_pExprVar)
		return m_pExprVar->GetVarName();
	else
		return "";
}
//CXISLTag* CXISLSwitchTag::FindTag(POINT point,BOOL bOnly)
//@\@FNbNꂽ^OT
//@Fpoint:W
//		  bOnly:TRUE͎̎ĝݔf
//ԂlFY^OBNULL
CXISLTag* CXISLSwitchTag::FindTag(POINT point,BOOL bOnly)
{
	m_rectBMP.NormalizeRect();
	if(m_rectBMP.PtInRect(point))
		return (CXISLTag*)this;
	else if(!bOnly)
	{
		CXISLTag* pTag;
		POSITION pos = m_CaseList.GetHeadPosition();
		while(pos)
		{
			CXISLCaseTag* pCTag = (CXISLCaseTag*)m_CaseList.GetNext(pos);
			pTag = pCTag->FindTag(point,TRUE);
			if(pTag)
				return pTag;
		}
	}

	return NULL;
}

//CSize CXISLSwitchTag::DrawXISLFlow(CDC *pDC,int nX,int nY)
//@\@Fexchange̗}
//@FCDC *pDC:foCXReLXg
//		  int nX, nY:`Jnʒu
//ԂlFCSize:`͈
CSize CXISLSwitchTag::DrawXISLFlow(CDC *pDC,int nX,int nY)
{
	int nViewSizeX,nViewSizeY;

	CDC MemDC;
	MemDC.CreateCompatibleDC(pDC);
		
	CBitmap FlowBMP;
	BITMAP bmp;

	FlowBMP.LoadBitmap(m_nBmpID);

	FlowBMP.GetBitmap(&bmp);
	CBitmap *pOldBMP = MemDC.SelectObject(&FlowBMP);

	pDC->BitBlt(nX,nY,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
	FlowBMP.DeleteObject();
	SetRectBMP(nX,nY,bmp.bmWidth,bmp.bmHeight);

	nX += bmp.bmWidth/2;
	nY += bmp.bmHeight-1;

	pDC->MoveTo(nX,nY);
	POINT point[3];
	point[0].x = nX;
	nY += 20;
	point[0].y = nY;
	nX += bmp.bmWidth;
	point[1].x = nX+5;
	point[1].y = nY;
	point[2].x = nX;
	nY += 35;
	point[2].y = nY;

	CPen *pOldPen,linePen;
	linePen.CreatePen(PS_SOLID,3,RGB(0,0,0));
	pOldPen = pDC->SelectObject(&linePen);

	pDC->PolyBezierTo(point,3);
		
	CFont *pOldFont;
	CFont font;
	font.CreateFont(12,0,0,0,FW_BOLD,TRUE,FALSE,FALSE,
		SHIFTJIS_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,
		DRAFT_QUALITY,DEFAULT_PITCH,_T("lr oSVbN"));
	pOldFont = pDC->SelectObject(&font);
	pDC->SetTextColor(RGB(80,80,80));
	pDC->SetBkMode(TRANSPARENT);
	CString strText = GetExpr();
	pDC->DrawText(strText,m_rectBMP,DT_CENTER|DT_NOCLIP|DT_VCENTER|DT_SINGLELINE);

	int nCount = m_CaseList.GetCount();
	int *npPoint = new int[nCount];
	int i=0,nStartX=nX,nStartY=nY;
	POSITION pos = m_CaseList.GetHeadPosition();
	while(pos)
	{
		CXISLCaseTag *pCTag = (CXISLCaseTag*)m_CaseList.GetNext(pos);
		FlowBMP.LoadBitmap(pCTag->m_nBmpID);
		FlowBMP.GetBitmap(&bmp);

		MemDC.SelectObject(&FlowBMP);
		pDC->BitBlt(nX-bmp.bmWidth/2,nY+10,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
		FlowBMP.DeleteObject();
		pCTag->SetRectBMP(nX-bmp.bmWidth/2,nY+10,bmp.bmWidth,bmp.bmHeight);
		npPoint[i] = nX;
		nX = nX + bmp.bmWidth + 20;

		strText = pCTag->GetValue();
		CRect rect;
		pCTag->GetRectBMP(&rect);
		pDC->DrawText(strText,rect,DT_CENTER|DT_NOCLIP|DT_VCENTER|DT_SINGLELINE);
		i++;
	}

	pDC->MoveTo(nStartX,nStartY);
	pDC->LineTo(npPoint[nCount-1],nStartY);
	for(i=0;i<nCount;i++)
	{
		pDC->MoveTo(npPoint[i],nY);
		pDC->LineTo(npPoint[i],nY+10);
	}

	delete [] npPoint;
	nViewSizeX = nX + bmp.bmWidth/2;
	nViewSizeY = nY + bmp.bmHeight;
	MemDC.SelectObject(pOldBMP);
	pDC->SelectObject(pOldFont);
	FlowBMP.DeleteObject();
	MemDC.DeleteDC();

	return CSize(nViewSizeX+100,nViewSizeY+100);
}

BOOL CXISLSwitchTag::SetAttribute(CXISLVar *pVar,CPtrList *pCaseList)
{
	m_pExprVar = pVar;
	POSITION pos = pCaseList->GetHeadPosition();
	while(pos)
		m_CaseList.AddTail(pCaseList->GetNext(pos));
	
	return TRUE;
}

BOOL CXISLSwitchTag::SetAttribute(LPCTSTR lpszExpr)
{
	CXISLExcItem *pExcItem = (CXISLExcItem*)m_pParentTag->GetParentExcTag();
	m_pExprVar = pExcItem->m_pLocalVar->FindVarWithParent(lpszExpr);
	if(m_pExprVar == NULL)
		return FALSE;

	m_pExprVar->ReferCount(TRUE);

	return TRUE;
}

BOOL CXISLSwitchTag::InsertCase(CXISLCaseTag *pCTag)
{
	if(pCTag->m_nTagType == ID_TAG_OTHER)
	{
		if(!m_CaseList.IsEmpty())
		{
			CXISLCaseTag *pLastCTag = (CXISLCaseTag*)m_CaseList.GetTail();
			if(pLastCTag->m_nTagType == ID_TAG_OTHER)
				return FALSE;
		}
	}

	if(HasOtherTag())
	{
		POSITION pos = m_CaseList.GetTailPosition();
		m_CaseList.InsertBefore(pos,pCTag);
	}
	else
		m_CaseList.AddTail(pCTag);

	pCTag->m_pParentTag = this;
	return TRUE;
}

//Case^O폜
//2003/5/16@
BOOL CXISLSwitchTag::DeleteCase(CXISLCaseTag *pCtag)
{
	POSITION pos = m_CaseList.Find(pCtag);
	if(pos==NULL)return FALSE;
	POSITION posdel = pos;
	m_CaseList.RemoveAt(posdel);
	delete pCtag;
	pCtag=NULL;
	return TRUE;
}

//Case̒ɃANV^Oꍇ̃^O폜
//2003/5/16@
BOOL CXISLSwitchTag::DeleteItemIntoCase()
{
	CXISLActItem *pActItem;
	CXISLSwitchTag *pSTag;
	CXISLCaseTag *pCTag;
	POSITION pos,posdel;

	while(m_CaseList.IsEmpty()==FALSE){
		pCTag = (CXISLCaseTag*)m_CaseList.GetHead();
		while(pCTag->m_ActionList.IsEmpty()==FALSE){
			//擪̃ANV^O擾
			pActItem = (CXISLActItem*)pCTag->m_ActionList.GetHead();
			//Switch^ȌꍇDeleteSwitch֍ċA
			if(pActItem->m_nTagType==ID_TAG_SWITCH){
				pSTag = (CXISLSwitchTag *)pCTag->m_ActionList.GetHead();
				pSTag->DeleteItemIntoCase();
				//pSTag폜
				pos = pCTag->m_ActionList.Find(pSTag);
				if(pos==NULL)return FALSE;
				posdel = pos;
				pCTag->m_ActionList.RemoveAt(posdel);
				delete pSTag;
				pSTag=NULL;
			}
			else {
				//Ƀ^OCALL܂GOTȌꍇXgϐXg폜^O폜
				if(pActItem->m_nTagType == ID_TAG_CALL || pActItem->m_nTagType == ID_TAG_GOTO){
					CXISLCallTag *pCallTag = (CXISLCallTag *)pCTag->m_ActionList.GetHead();
					pCallTag->DeleteList();
					pos = pCTag->m_ActionList.Find(pCallTag);
					if(pos==NULL)return FALSE;
					posdel = pos;
					pCTag->m_ActionList.RemoveAt(posdel);
					delete pCallTag;
					pCallTag = NULL;
				}
				//ELSEIFIF̏ꍇ폜
				else if(pActItem->m_nTagType == ID_TAG_IF || pActItem->m_nTagType == ID_TAG_ELSEIF){
					CXISLIfTag *pIfTag = (CXISLIfTag *)pCTag->m_ActionList.GetHead();
					pIfTag->DeleteALL();
					pos = pCTag->m_ActionList.Find(pActItem);
					if(pos==NULL)return FALSE;
					posdel = pos;
					pCTag->m_ActionList.RemoveAt(posdel);
					delete pIfTag;
					pIfTag=NULL;
				}
				//ȊÕ^O͍폜
				else {
					pos = pCTag->m_ActionList.Find(pActItem);
					if(pos==NULL)return FALSE;
					posdel = pos;
					pCTag->m_ActionList.RemoveAt(posdel);
					delete pActItem;
					pActItem=NULL;
				}
			}
		}
		DeleteCase(pCTag);
		//̗vf擾
	}
	return TRUE;
}

//w肵Case^OɃANVȂ`FbN(ꍇ͍폜)
BOOL CXISLSwitchTag::DeleteItemIntoCase(CXISLCaseTag *pCTag)
{
	CXISLActItem *pActItem;
	CXISLSwitchTag *pSTag;
	POSITION pos,posdel;

	while(pCTag->m_ActionList.IsEmpty()==FALSE){
		//擪̃ANV^O擾
		pActItem = (CXISLActItem*)pCTag->m_ActionList.GetHead();
		//Switch^ȌꍇDeleteSwitch֍ċA
		if(pActItem->m_nTagType==ID_TAG_SWITCH){
			//ċAĂяos
			pSTag = (CXISLSwitchTag *)pCTag->m_ActionList.GetHead();
			pSTag->DeleteItemIntoCase();
			//pSTag폜
			pos = pCTag->m_ActionList.Find(pSTag);
			if(pos==NULL)return FALSE;
			posdel = pos;
			pCTag->m_ActionList.RemoveAt(posdel);
			delete pSTag;
			pSTag = NULL;
		}
		else {
			//Ƀ^OCALL܂GOTȌꍇXgϐXg폜^O폜
			if(pActItem->m_nTagType == ID_TAG_CALL || pActItem->m_nTagType == ID_TAG_GOTO){
				CXISLCallTag *pCallTag = (CXISLCallTag *)pCTag->m_ActionList.GetHead();
				pCallTag->DeleteList();
				pos = pCTag->m_ActionList.Find(pCallTag);
				if(pos==NULL)return FALSE;
				posdel = pos;
				pCTag->m_ActionList.RemoveAt(posdel);
				delete pCallTag;
				pCallTag = NULL;
			}
			//ELSEIFIF̏ꍇ폜
			else if(pActItem->m_nTagType == ID_TAG_IF || pActItem->m_nTagType == ID_TAG_ELSEIF){
				CXISLIfTag *pIfTag = (CXISLIfTag *)pCTag->m_ActionList.GetHead();
				pIfTag->DeleteALL();
				pos = pCTag->m_ActionList.Find(pActItem);
				if(pos==NULL)return FALSE;
				posdel = pos;
				pCTag->m_ActionList.RemoveAt(posdel);
				delete pIfTag;
				pIfTag=NULL;
			}
			//ȊÕ^O͍폜
			else {
				pos = pCTag->m_ActionList.Find(pActItem);
				if(pos==NULL)return FALSE;
				posdel = pos;
				pCTag->m_ActionList.RemoveAt(posdel);
				delete pActItem;
				pActItem = NULL;
			}
		}

	}
	return DeleteCase(pCTag);
}
